#!/usr/bin/perl
# Open Admin backup script - does entire /opt/openadmin installation+db+conf

# Configuration Values
# Change these!
my $dbuser = 'global'; # user will need: select, lock tables, show view privileges for mysqldump
my $dbpassword = 'gron782';  #
my $remoteip = '10.162.70.33'; # Mory.tsec.ca
my $scpport = '3001'; # changed from normal SSH port


##### Secondary Offsite Backup
my $remoteip2 = '69.11.91.94'; # Hawk
my $scpport2 = '3001';
#####################


##### Tertiary Offsite Backup - no longer available.
 my $remoteip3 = '10.188.253.180'; # Onion Lake Server... Sauron
 my $scpport3 = '3001';
#####################



my $mysqldumpexec = '/usr/bin/mysqldump';
my $scpexec = '/usr/bin/scp';
my $tarexec = '/bin/tar';
my $dbtype = 'mysql';

my $backupDir = '/tmp/openadmin';
my $apacheDir = '/etc/apache2';

# Used for Filename Date
my @smonth = ('JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC');


use DBI;


my @tim = localtime(time);
my $year = $tim[5] + 1900;

my $day = $tim[3];
if ( length( $day ) == 1 ) { $day = '0'. $day; }

# For Filename
#my $filecurrdate = $tim[3]. $smonth[ $tim[4] ]. $fyear;
my $filecurrdate = $year. $smonth[ $tim[4] ]. $day;


my $minutes = $tim[1];
if ( not $minutes ) { $minutes = '00'; }
my $filecurrtime = $tim[2]. $minutes;
# Time goes on....
for (0..4){if (length($tim[$_]) == 1){ $tim[$_] = '0'.$tim[$_];}}
my $currdate = "$year-$tim[4]-$tim[3]";
my $currtime = "$tim[2]:$tim[1]:$tim[0]";


#### Files #########
# Empty and create new directories to hold backup.
if ( -e $backupDir ) {
    system("rm -rf $backupDir");
}

mkdir $backupDir;
mkdir "$backupDir/files";
mkdir "$backupDir/dbase";
mkdir "$backupDir/conf";


# Backup directory into /tmp
my $res = system("cp -rp /opt/openadmin/* $backupDir/files");

# Delete Backup Folder
my $res = system("rm -fr $backupDir/files/backup");

# Strip out the download files
my @dirs;
push @dirs,$backupDir;
use File::Find;
find( \&removeDownloads, @dirs );

sub removeDownloads {
    my $dir = $File::Find::dir;
    if ( $dir =~ m/.+download$/ ) {
	# print "Match: $dir\n";
	unlink $_;
    }

    if ( $dir =~ m/.+reportcard$/ ) {
	# print "Match: $dir\n";
	unlink $_;
    }

}


#### Databases ######

my $dsn = "DBI:$dbtype:";
my $dbh = DBI->connect($dsn,$dbuser,$dbpassword);
if ( $DBI::errstr ) { print $DBI::errstr; die }

my $sth = $dbh->prepare("show databases;");
$sth->execute;
if ( $DBI::errstr ) { print $DBI::errstr; die }

my @databases;
while ( my $db = $sth->fetchrow ) {
    if ( $db eq 'information_schema' ) { next; }
    push @databases, $db;
}

# Backup each database in turn and place in /tmp/openadmin/dbase
foreach my $dbase ( @databases ) {
#    print "DBASE:$dbase\n";
    if ( $dbase eq 'performance_schema' or $dbase eq 'sys' ) { next; }
    system("$mysqldumpexec -p$dbpassword -u $dbuser $dbase > $backupDir/dbase/$dbase.sql");
}


#### Configuration (Apache) ##############
# get the /etc/apache2/sites and /etc/apache/auth_users data.

my $res = system("cp -r $apacheDir/auth_users $backupDir/conf");
my $res = system("cp -r $apacheDir/sites-available $backupDir/conf");
my $res = system("cp -r $apacheDir/sites-enabled $backupDir/conf");
my $res = system("cp -r $apacheDir/mods-enabled $backupDir/conf");


# Backup Scripts
my $res = system("cp -r /usr/local/bin $backupDir/conf");

# Compress the directory into tarred gzip file. Scp to backup server.
my $filename = 'Backup_'. $filecurrdate. '_'. $filecurrtime. '.tar.bz2';
my $res = system("$tarexec -cvjf /tmp/$filename $backupDir >>/dev/null");


# Copy to external servers - note the name of the backup dir on remote server.
# Send to Mory
system("$scpexec -P $scpport /tmp/$filename root\@$remoteip:backup/$filename");

# Send to Hawk
system("$scpexec -P $scpport2 /tmp/$filename root\@$remoteip2:backuptsec/$filename");

# Send to Onion Lake
 system("$scpexec -P $scpport3 /tmp/$filename root\@$remoteip3:backuptsec/$filename");


system("rm -f /tmp/$filename");

 print "Done\n";
exit;
