#!/usr/bin/perl
#  Copyright 2001-2023 Leslie Richardson

#  This file is part of Open Admin for Schools.

use DBI;
use Text::CSV_XS;

my $user = 'root';
my $password = 'sezme';
my $dbtype = 'mysql';


my $exportDir = "./mss";
my @schooldb = ('sese','mist');


my $remotehost = 'sftp.myschoolsask.ca';
my $remoteuser = 'sd995pdmsstreatysix';
# my $remotepassword = 'EIYjtsu1hZXocmViR2B!'; for integration envrionment
my $remotepassword = '1QpY2hURKitUgBSu8Oa!';

# configure schools to download
my @stud = qw(cjk mist);
my @trn = qw(cjk);
my @crs = qw(cjk);


# Empty and create new directory to hold export
if ( -e $exportDir ) {
    system("rm -rf $exportDir");
}

mkdir $exportDir;


doTransfer(); # download files via SFTP
parseStudentFile(); # replace existing student records
parseTranscriptFile(); # only add new records.
parseCourseFile(); # only add new current course records 


#-------------
sub doTransfer {  # download files to mssdownload directory
#-------------

    #foreach my $key (keys %arr) { print "K:$key V:$arr{$key}<br>\n"; }

    my @files;
    foreach my $stud ( @stud ) {
	my $fn = $stud. 'stud.csv';
	push @files, $fn;
    }

    foreach my $trn ( @trn ) {
	my $fn = $trn. 'trn.csv';
	push @files, $fn;
    }

    foreach my $crs ( @crs ) {
	my $fn = $crs. 'crs.csv';
	push @files, $fn;
    }

#    print qq{Files: @files\n};
    
    use Net::SFTP::Foreign;

    my %args = ('user' => $remoteuser, 'password' => $remotepassword );

    my $sftp = Net::SFTP::Foreign->new($remotehost, %args );
    $sftp->die_on_error("Cannot extablish a connection!\n");

    print qq{Starting Download\n};
    
    foreach my $f ( @files ) {
	my $file = "/mnt/sftp/$remoteuser/$f";
	my $destpath = "$exportDir/$f";
	$sftp->get($file, $destpath) or die "Put Failed for file $file: ". $sftp->error;
#	$sftp->remove($file) or die "Remove Failed for file $file: ". $sftp->error;
    }

    # files are now in mss directory
    print qq{Done FTP Import!\n};
   
    return;
}


#-------------------
sub parseStudentFile {  # replace mss student table with latest data.
#-------------------

    foreach my $sch ( @stud ) { # update each database/school

	my ($filename,$db);
	if ( $sch eq 'cjk' ) { # really the sese database this year
	    $filename = qq{$exportDir/cjkstud.csv};
	    $db = 'sese';
	} else { # no need to tweak
	    $filename = qq{$exportDir/$sch}. qq{stud.csv};
	    $db = $sch; # both the same db and school
	}

	print "School:$sch DB:$db Filename:$filename\n";
	
	my $dsn = "DBI:$dbtype:dbname=$db";
	my $dbh = DBI->connect($dsn,$user,$password);
	$dbh->{mysql_enable_utf8} = 1;

	my $csv = Text::CSV_XS->new( {binary => 1} );
    

	unless ( open ( FH,"<$filename" ) ) {
	    print $lex{'Cannot open file'}. ": $!\n";
	    die $lex{'Cannot open file'}. ": $!\n";
	}

    
	# Empty the mss_student table. We want the latest students
	my $sth = $dbh->prepare("truncate mss_student");
	$sth->execute;
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

    
	my $sth = $dbh->prepare("insert into mss_student (mssid,provnum,legal_firstname,
				legal_lastname, birthdate,grade, firstname, lastname) 
				values(?,?,?,?,?,?,?,?)");
    
	my $heading = <FH>; # read the columns descriptions.
    
	while ( my $line = <FH> ) {
	    #print qq{LINE: $line<br>\n};
	    my @fields;
	
	    if ( $csv->parse($line) ) {
		
		my @fields = $csv->fields;
		my @new;
		foreach my $idx ( 0,1,2,3,4,5,10,11 ) {
		    push @new, $fields[$idx];
		}

		$sth->execute( @new ); # insert into table.
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    
	    } # end of line parse

	} # end of this line read.

	close FH;
	#    system("rm -f $filename");

	print qq{Import into MSS Student Table complete - $db\n};
	
    } # end of sch loop

    return;

}


#----------------------
sub parseTranscriptFile {  # only add records if integration doesn't exist
#----------------------


    foreach my $sch ( @trn ) { # update each database/school

	my ($filename,$db);
	if ( $sch eq 'cjk' ) { # really the sese database this year
	    $filename = qq{$exportDir/cjktrn.csv};
	    $db = 'sese';
	} else { # no need to tweak
	    $filename = qq{$exportDir/$sch}. qq{trn.csv};
	    $db = $sch; # both the same db and school
	}

        
	my $dsn = "DBI:$dbtype:dbname=$db";
	my $dbh = DBI->connect($dsn,$user,$password);
	$dbh->{mysql_enable_utf8} = 1;

	my $csv = Text::CSV_XS->new( {binary => 1} );
    

	unless ( open ( FH,"<$filename" ) ) {
	    print $lex{'Cannot open file'}. ": $!\n";
	    die $lex{'Cannot open file'}. ": $!\n";
	}

    
	# Six values
	my $sth = $dbh->prepare("insert into mss_transcript 
				(mssid,coursecode,integrationid,date,mark,credit) 
				values(?,?,?,?,?,?)");

	my $sth1 = $dbh->prepare("select count(*) from mss_transcript where integrationid = ?");
    
    
	my $heading = <FH>; # read the columns descriptions.
    
	while ( my $line = <FH> ) {
	    #print qq{LINE: $line<br>\n};
	    my @fields;
	
	    if ( $csv->parse($line) ) {

		my @fields = $csv->fields;
		my $intid = $fields[2]; # integrationid

		# check if the integrationid is found. if so skip to next record
		$sth1->execute( $intid );
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
		my $count = $sth1->fetchrow;
		if ( $count ) {
		    # print "Skipping $intid\n";
		    next;
		};

#		print qq{Adding New Record!\n};  # NOTE: Could also add to completed recs here!
		# new record to add
		my @new;
		foreach my $idx ( 0,1,2,4,5,6 ) {
		    push @new, $fields[$idx];
		}
	    
		$sth->execute( @new ); # insert into table.
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	    } # end of line parse
    
	} # end of line reads.

	close FH;
	# system("rm -f $filename");
	
	print qq{Import into MSS Transcript Table complete - $sch\n};

	my %mss2pn; # map mssid to provnum

	# find provnum,dob to match with mssid;
	my $sth1 = $dbh->prepare("select provnum,birthdate from studentall where mssid = ?");

	my $sth2 = $dbh->prepare("select title from sasked_courses where code = ?");
	
	my $sth3 = $dbh->prepare("insert into sasked_completedcourses 
				 ( provnum,birthdate,schoolname,courseid,coursetitle,schoolyear,
				 courseenddate,finalmark,creditsearned,mssid)
				 values(?,?,?,?,?,?,?,?,?,?)");  # 10 fields

	# Find an existing record
	my $sth4 = $dbh->prepare("select count(*) from sasked_completedcourses where 
				 courseid = ? and provnum = ? and courseenddate = ?");

	my $sth5 = $dbh->prepare("select firstname, lastname from studentall where provnum = ?");
	
	
	# now add any new records into the normal completed courses.
	my $sth = $dbh->prepare("select * from mss_transcript order by mssid");
	$sth->execute;
	if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	while ( my $ref = $sth->fetchrow_hashref ) {
	    my %r = %$ref;

	    if ( not $r{date} or not $r{mark} ){ next; }
	    
	    my ($provnum,$birthdate);
	    
	    my $pndob = $mss2pn{ $r{mssid} }; # combined provnum and birthdate
    
	    if ( not defined $pndob ) { # look it up if possible
		
		# provnum, dob
		$sth1->execute( $r{mssid} );
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
		($provnum,$birthdate) = $sth1->fetchrow;

		if ( not $provnum ) {
#		    print qq{Skipping - Matching Student not found for $r{id} - MSSID: $r{mssid}\n};
		    next;
		} else { # we found it, populate hash
		    $mss2pn{$r{mssid}} = qq{$provnum:$birthdate};
		}
		
	    } else { # we have data in hash.
		($provnum,$birthdate) = split(':',$pndob);
	    }
	    # we have provnum and birthdate at this point. School name and id not possible.
	    
#	    print "DATA:$pndob MSSID:$r{mssid} Date:$r{date} Birthdate:$birthdate\n";

	    
	    # Check for an existing record, since we now have a provincial number
	    $sth4->execute( $r{coursecode}, $provnum, $r{date} );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    my $recexists = $sth4->fetchrow;
	    if ( $recexists ) {
#		print qq{Transcript Record Exists. Skipping.\n};
		next;
	    }
	    
	    
	    # Use coursecode to find course title.
	    $sth2->execute( $r{coursecode} );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    my $coursetitle = $sth2->fetchrow; 

	    # Check for a bad date
	    if ( $r{date} eq '0000-00-00' ) { # problem, look up name

		# Get name
		$sth5->execute( $provnum );
		if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
		my ($fn,$ln) = $sth5->fetchrow;
		
		print qq{Blank Date for $fn $ln ($provnum / $r{mssid}) - };
		print qq{$r{coursecode} / $coursetitle / $r{mark}\n};
	    }
	    
	    
	    # Calculate school year from end date.
	    my $schoolyear;
	    my ($y,$m,$d) = split('-', $r{date});
	    if ( $m > 7 ) { # bump up the year to get ending year.
		$y++; # thus if we have a 11 month, then the end year must be increased.
	    }
	    my $prevyear = $y - 1;
	    my $schoolyear = qq{$prevyear-$y};

	    
	    # insert record into SkEd CompCourses table.
	    my $schoolname = qq{MSS Missing School};
	    
	    $sth3->execute( $provnum, $birthdate, $schoolname, $r{coursecode},$coursetitle,
			    $schoolyear,$r{date},$r{mark},$r{credit},$r{mssid} );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }

	    $count++;
#	    if ( $count > 10 ) { exit; }

	} # end of transcript reading loop


    } # end of sch loop


    return;

}


#-------------------
sub parseCourseFile {  # 
#-------------------

    my $filename = "$exportDir/cjkcrs.csv";
    my $dbase = 'sese'; # now Chief John Keenatch
    
    my $dsn = "DBI:$dbtype:dbname=$dbase";
    my $dbh = DBI->connect($dsn,$user,$password);
    $dbh->{mysql_enable_utf8} = 1;

    my $csv = Text::CSV_XS->new( {binary => 1} );
    

    unless ( open ( FH,"<$filename" ) ) {
	print $lex{'Cannot open file'}. ": $!\n";
	die $lex{'Cannot open file'}. ": $!\n";
    }

    
    # Empty the mss_currcourse table.
    my $sth = $dbh->prepare("truncate mss_currcourse");
    $sth->execute;
    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }


    # Read in file record, check for it in transcript table (using
    # integration id). If not found, then add that record to the
    # current courses.
        

    my $sth = $dbh->prepare("insert into mss_currcourse
			    (mssid,coursecode,integrationid) values(?,?,?)");
    # skip date,mark,credit which will be blank.

    my $sth1 = $dbh->prepare("select count(*) from mss_transcript where integrationid = ?");
    my $sth2 = $dbh->prepare("select count(*) from mss_currcourse where integrationid = ?");

    
    my $heading = <FH>; # read the columns descriptions.
    
    while ( my $line = <FH> ) {
	#print qq{LINE: $line<br>\n};
	my @fields;
	
	if ( $csv->parse($line) ) {

	    my @fields = $csv->fields;
	    my $intid = $fields[2]; # integrationid
	    if ( not $intid ) {
		print qq{Missing Integration ID: $fields[0] / $fields[1]\n};
	    }
	    
	    # check if the integrationid is found. If found, then this
	    # is a completed course, and not a current course. Skip
	    # this record
	    
	    $sth1->execute( $intid );
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
	    my $count = $sth1->fetchrow;
	    if ( $count ) {
		next;
	    };

	    # check for integrationid,date, mark, credit, which should be blank.
	    foreach my $idx (4,5,6) {
		if ( $fields[$idx] ) {
		    print qq{Unexpected value (intid,date,mark,credit): $fields[$idx] / $idx<br>\n};
		}
	    }


	    # add a new current course record
	    my @new;
	    foreach my $idx ( 0,1,2 ) {
		push @new, $fields[$idx];
	    }


	    # check if we already have this record in currcourse table
#	    $sth2->execute( $intid );
#	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
#	    my $count = $sth2->fetchrow;
#	    if ( $count ) {
#		print qq{Course already added to current courses\n};
#		next;
#	    };
	    
	    
	    $sth->execute( @new ); # insert into table.
	    if ( $DBI::errstr ) { print $DBI::errstr; die $DBI::errstr; }
#	    print qq{Adding New Current Course Record! @new \n};
	    
	} # end of line parse

	    
    } # end of this line read.

    close FH;
#    system("rm -f $filename");

    print qq{Import into MSS Current Course Table complete\n};

    return;

}


